import dotenvx from '@dotenvx/dotenvx'

let HAS_ALREADY_RAN = false;
export function tryLoadEnv() {
    if (HAS_ALREADY_RAN) {
        return;
    }

    if (!process.env.CDK_CONTEXT_JSON) {
        throw new Error("CDK backend config: env.CDK_CONTEXT_JSON must be set up before running")
    }

    const cxt = JSON.parse(process.env.CDK_CONTEXT_JSON)
    if (cxt['amplify-backend-type'] !== "sandbox") {
        return;
    }

    dotenvx.config()
    HAS_ALREADY_RAN = true;
}

